
<?php
//add by morteza for sms
//گرفتن تنظیمات نوع ورود به سایت
$type = get_option('enable_mobile_in_forget_password', 0);

?>
<div class="auth-login-form">
    <div class="form-login">
        <form class="actionForm" action="<?= cn("auth/ajax_forgot_password") ?>" data-redirect="<?= cn("auth/login") ?>" method="POST">
            <div>
                <div class="card-title text-center">
                    <div class="site-logo">
                        <a href="<?= cn() ?>">
                            <img src="<?= get_option('website_logo', BASE . "assets/images/logo.png") ?>" alt="website-logo">
                        </a>
                    </div>
                    <h4><?= lang("forgot_password") ?></h4>
                </div>
                <?php if ($type == 0) { ?>
                    <p class="text-muted"><?= lang("enter_your_registration_email_address_to_receive_password_reset_instructions") ?></p>
                    <div class="form-group">
                        <div class="input-icon mb-5">
            <span class="input-icon-addon">
              <i class="fe fe-mail"></i>
            </span>
                            <input type="email" class="form-control" name="email" placeholder="<?= lang("Email") ?>" required>
                        </div>
                    </div>
                <?php } else { ?>
                    <div class="form-group">
                        <div class="input-icon mb-5">
            <span class="input-icon-addon">
              <i class="fa fa-mobile"></i>
            </span>
                            <input type="text" class="form-control" name="mobile" id="mobile-number" dir="ltr" placeholder="موبایل"
                                   value="<?= (isset($cookie_mobile) && $cookie_mobile != "") ? $cookie_mobile : "" ?>"
                                   oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required>
                        </div>

                        <div class="input-icon mb-5 otp-password" style="display: none">
            <span class="input-icon-addon">
              <i class="fa fa-key"></i>
            </span>
                            <input type="password" class="form-control" name="password" id="password" placeholder="رمز عبور جدید"
                                   value="" required>
                        </div>


                        <div class="input-icon mb-5 otp-code" style="display: none">
            <span class="input-icon-addon">
              <i class="fa fa-key"></i>
            </span>
                            <input type="text" style="text-align: center" id="otp-code" dir="ltr" class="form-control" name="otp-code"
                                   oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" placeholder="کد تایید">

                        </div>

                        <label class="custom-control sub-otp-code" style="padding-right:0;display: none">
                            <span style="display: inline-block;">
                                <span id="forget-sms-timer">00 ثانیه</span>
                       </span>
                            <a href="#" class="float-right small disabled" id="forget-send-active-code">ارسال مجدد کد تایید</a>
                        </label>

                    </div>
                <?php } ?>
                <?php
                if (get_option('enable_goolge_recapcha') && get_option('google_capcha_site_key') != "" && get_option('google_capcha_secret_key') != "" && $type == 0) { ?>) {
                    ?>
                    <div class="form-group">
                        <div class="g-recaptcha" data-sitekey="<?= get_option('google_capcha_site_key') ?>"></div>
                    </div>
                <?php } ?>

                <div class="form-footer">
                    <button type="submit" class="btn btn-pill btn-2 btn-block btn-submit btn-gradient <?php if ($type == 1) { ?>send-otp-code<?php } ?>"><?= lang("Submit") ?></button>
                </div>
            </div>
        </form>
    </div>
</div>
<script>

    jQuery(document).ready(function ($) {

        $('body').on('click', '.send-otp-code', function (e) {
            e.preventDefault();
            send_otp_request();

        });

        $('body').on('click', '#forget-send-active-code', function (e) {
            e.preventDefault();
            onTimer("forget");
            send_otp_request();
        })
    });

    /**
     * set 60 sec before resend active code
     */
    function onTimer(type) {
        //type is login or forget or remember
        //timer
        var count = <?= get_option('delay_sms', "60") ?>;
        $("#" + type + "-send-active-code").addClass('disabled');
        var timer = setInterval(function () {
            $("#" + type + "-sms-timer").html(count-- + " ثانیه");
            if (count == 0) {

                $("#" + type + "-sms-timer").text("");
                $("#" + type + "-send-active-code").removeClass('disabled');
                $("#" + type + "-send-active-code").prop("disabled", false);
                $("#" + type + "-status-active-code").text("");
                $("#" + type + "-send-active-code").css("cursor", "pointer");

                clearInterval(timer)
            }
        }, 1000);

    }

    function send_otp_request() {
        let $mobile = $('#mobile-number').val();
        // let $email = $('#email').val();
        let $password = $('#password').val();
        let $code = $('#otp-code').val();
        $.ajax({
            type: 'post',
            url: "<?= cn("auth/ajax_forgot_password") ?>",
            data: 'mobile=' + $mobile + '&password=' + $password + '&code=' + $code + '&token=' + token + '&type=forget-password',
            beforeSend: function () {
                pageOverlay.show();
            },
            success: function (result) {

                setTimeout(function () {
                    pageOverlay.hide();
                }, 1500);


                result = JSON.parse(result);
                if (result.type === "send_otp") {

                    //نشون دادن اطلاعیه
                    setTimeout(function () {
                        notify(result.message, result.status);
                    }, 1500);

                    //اگر موفق بود فیلد وارد کردن کد رو نشون بده
                    if (result.status === "success") {
                        onTimer("forget");
                        $('.otp-code').show();
                        $('.otp-password').show();
                        $('.sub-otp-code').show();
                        $('.send-otp-code').text('بررسی کد تایید');
                    }

                } else {
                    //اگر موفق بود فیلد وارد کردن کد رو نشون بده
                    if (result.status === "success") {
                        //نشون دادن اطلاعیه
                        notify(result.message, result.status);
                        setTimeout(function () {
                            window.location.replace("<?= cn('auth/login') ?>");
                        }, 3000);

                    } else {
                        //نشون دادن اطلاعیه
                        setTimeout(function () {
                            notify(result.message, result.status);
                        }, 2000);
                    }
                }


            }
        });
    }
</script>

