<style>
  .api-documentation pre{
    background: #293340;
    color: #f8f8f2;
    border-radius: 0px;
  }

  .smart-remove {
      color: #E84393;
      background: #fff;
      padding: 3px;
      border: 1px solid #d9d8d8;
      border-radius: 3px;
  }
  .swal2-popup.swal2-toast .swal2-title {
      font-size: 12px !important;
      text-align: center !important;
  }
</style>

<div class="row justify-content-center api-documentation">
  <div class="col-md-8">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title"><?=lang("api_documentation")?></h3>
        <div class="card-options">
          <a href="#" class="card-options-collapse" data-toggle="card-collapse"><i class="fe fe-chevron-up"></i></a>
          <a href="#" class="card-options-remove" data-toggle="card-remove"><i class="fe fe-x"></i></a>
        </div>
      </div>
      <div class="card-body collapse show">
        <div class="x_content">
          <p class="note"><?=lang("note_please_read_the_api_intructions_carefully_its_your_solo_responsability_what_you_add_by_our_api")?></p>
          <table class="table table-hover table-bordered projects">
            <thead>
              <tr>
                <td><?=lang("http_method")?></td>
                <td>POST</td>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td><?=lang("response_format")?></td>
                <td>Json</td>
              </tr>
              <tr>
                <td><?=lang('api_url')?></td>
                <td style="direction: ltr;text-align: left;">
                    <a href="<?=$api_url?>"><?=$api_url?></a>
                    <a href="<?=$api_url?>" class="smart-remove CopyToClipBoard"><i class="fa fa-copy"></i></a><!--add by morteza-->
                </td>
              </tr>

              <tr>
                <td><?=lang("api_key")?></td>
                <td style="direction: ltr;text-align: left;">
                    <?=$api_key?>
                    <a href="<?=(!empty($api_key))? $api_key: ''?>" class="smart-remove CopyToClipBoard"><i class="fa fa-copy"></i></a><!--add by morteza-->
                </td>
              </tr>
          </table>
          <div class="card-footer">
            <div class="row">
              <div class="col-md-12 col-sm-12 col-xs-12">
                <a href="<?=BASE?>example.txt" class="btn btn-round btn-primary" target="_blank"><?=lang("download_php_code_examples")?></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-md-8">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title"><?=lang("place_new_order")?></h3>
        <div class="card-options">
          <a href="#" class="card-options-collapse" data-toggle="card-collapse"><i class="fe fe-chevron-up"></i></a>
          <a href="#" class="card-options-remove" data-toggle="card-remove"><i class="fe fe-x"></i></a>
        </div>
      </div>
      <div class="card-body">
        <div class="form-group x_content">
          <select name="service-type" class="form-control ajaxChangeOrderType m-b-20">
            <option value="default"> Default</option>
            <option value="custom_comments"> Custom Comments</option>
          </select>
          <!-- Default -->
          <table class="table table-hover table-bordered service-default">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>key</td>
                <td>Your API key</td>
              </tr>
              <tr>
                <td>action</td>
                <td>add</td>
              </tr>
              <tr>
                <td>service</td>
                <td>Service ID</td>
              </tr>
              <tr>
                <td>link</td>
                <td>Link to page</td>
              </tr>
              <tr>
                <td>quantity</td>
                <td>Needed quantity</td>
              </tr>
              <tr>
                <td>runs (optional)</td>
                <td>Runs to deliver</td>
              </tr>
              <tr>
                <td>interval (optional)</td>
                <td>Interval in minutes</td>
              </tr>
            </tbody>
          </table>  

          <!-- package -->
          <table class="table table-hover table-bordered service-package d-none">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>key</td>
                <td>Your API key</td>
              </tr>
              <tr>
                <td>action</td>
                <td>add</td>
              </tr>
              <tr>
                <td>service</td>
                <td>Service ID</td>
              </tr>

              <tr>
                <td>link</td>
                <td>Link to page</td>
              </tr>

            </tbody>
          </table>

          <!-- Custom Comments -->
          <table class="table table-hover table-bordered service-custom-comments d-none">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>key</td>
                <td>Your API key</td>
              </tr>
              <tr>
                <td>action</td>
                <td>add</td>
              </tr>
              <tr>
                <td>service</td>
                <td>Service ID</td>
              </tr>
              <tr>
                <td>link</td>
                <td>Link to page</td>
              </tr>
              <tr>
                <td>comments</td>
                <td>Comments list separated by \r\n or \n</td>
              </tr>
            </tbody>
          </table>

          <!-- mentions_with_hashtags -->
          <table class="table table-hover table-bordered service-mentions-with-hashtags d-none">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>key</td>
                <td>Your API key</td>
              </tr>
              <tr>
                <td>action</td>
                <td>add</td>
              </tr>
              <tr>
                <td>service</td>
                <td>Service ID</td>
              </tr>
              <tr>
                <td>link</td>
                <td>Link to page</td>
              </tr>
              <tr>
                <td>quantity</td>
                <td>Needed quantity</td>
              </tr>
              <tr>
                <td>usernames</td>
                <td>Usernames list separated by \r\n or \n</td>
              </tr>
              <tr>
                <td>hashtags</td>
                <td>Hashtags list separated by \r\n or \n</td>
              </tr>
            </tbody>
          </table> 

          <!-- mentions_custom_list -->
          <table class="table table-hover table-bordered service-mentions-custom-list d-none">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>key</td>
                <td>Your API key</td>
              </tr>
              <tr>
                <td>action</td>
                <td>add</td>
              </tr>
              <tr>
                <td>service</td>
                <td>Service ID</td>
              </tr>
              <tr>
                <td>link</td>
                <td>Link to page</td>
              </tr>
              <tr>
                <td>usernames</td>
                <td>Usernames list separated by \r\n or \n</td>
              </tr>
            </tbody>
          </table>  

          <!-- mentions-hashtag -->
          <table class="table table-hover table-bordered service-mentions-hashtag d-none">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>key</td>
                <td>Your API key</td>
              </tr>
              <tr>
                <td>action</td>
                <td>add</td>
              </tr>
              <tr>
                <td>service</td>
                <td>Service ID</td>
              </tr>

              <tr>
                <td>link</td>
                <td>Link to page</td>
              </tr>

              <tr>
                <td>quantity</td>
                <td>Needed quantity</td>
              </tr>
             
              <tr>
                <td>hashtag</td>
                <td>Hashtag to scrape usernames from</td>
              </tr>

            </tbody>
          </table>

          <!-- mentions-user-followers -->
          <table class="table table-hover table-bordered service-mentions-user-followers d-none">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>key</td>
                <td>Your API key</td>
              </tr>
              <tr>
                <td>action</td>
                <td>add</td>
              </tr>
              <tr>
                <td>service</td>
                <td>Service ID</td>
              </tr>
              <tr>
                <td>link</td>
                <td>Link to page</td>
              </tr>
              <tr>
                <td>quantity</td>
                <td>Needed quantity</td>
              </tr>
              <tr>
                <td>username</td>
                <td>URL to scrape followers from</td>
              </tr>

            </tbody>
          </table> 

          <!-- custom-comments-package -->
          <table class="table table-hover table-bordered service-custom-comments-package d-none">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>key</td>
                <td>Your API key</td>
              </tr>
              <tr>
                <td>action</td>
                <td>add</td>
              </tr>
              <tr>
                <td>service</td>
                <td>Service ID</td>
              </tr>
              <tr>
                <td>link</td>
                <td>Link to page</td>
              </tr>
              <tr>
                <td>comments</td>
                <td>Comments list separated by \r\n or \n</td>
              </tr>

            </tbody>
          </table>  

          <!-- mentions-media-likers -->
          <table class="table table-hover table-bordered service-mentions-media-likers d-none">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>key</td>
                <td>Your API key</td>
              </tr>
              <tr>
                <td>action</td>
                <td>add</td>
              </tr>
              <tr>
                <td>service</td>
                <td>Service ID</td>
              </tr>

              <tr>
                <td>link</td>
                <td>Link to page</td>
              </tr>

            </tbody>
          </table>

          <!-- comment-likes -->
          <table class="table table-hover table-bordered service-comment-likes d-none">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>key</td>
                <td>Your API key</td>
              </tr>
              <tr>
                <td>action</td>
                <td>add</td>
              </tr>
              <tr>
                <td>service</td>
                <td>Service ID</td>
              </tr>
              <tr>
                <td>link</td>
                <td>Link to page</td>
              </tr>
              <tr>
                <td>quantity</td>
                <td>Needed quantity</td>
              </tr>
              <tr>
                <td>username</td>
                <td>Username of the comment owner</td>
              </tr>
            </tbody>
          </table>
          
          <!-- Subscriptions -->
          <table class="table table-hover table-bordered service-subscriptions d-none">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>key</td>
                <td>Your API key</td>
              </tr>
              <tr>
                <td>action</td>
                <td>add</td>
              </tr>
              <tr>
                <td>service</td>
                <td>Service ID</td>
              </tr>
              <tr>
                <td>username</td>
                <td>Username</td>
              </tr>
              <tr>
                <td>min</td>
                <td>Quantity min</td>
              </tr> 
              <tr>
                <td>max</td>
                <td>Quantity max</td>
              </tr>
              <tr>
                <td>delay</td>
                <td>Delay in minutes. Possible values: 0, 5, 10, 15, 30, 60, 90</td>
              </tr>
              <tr>
                <td>expiry (optional)</td>
                <td>Expiry date. Format d/m/Y</td>
              </tr>

            </tbody>
          </table>

          <div class="title"><h4><?=lang("example_response")?></h4></div>
          <div class="card-body">
            <pre>
{
  "status": "success",
  "order": 32
}
            </pre>
          </div>
        </div>            
      </div>
    </div>
  </div>
  
  <script>
    // callback ajaxChange
    $(document).on("change", ".ajaxChangeOrderType" , function(){
      event.preventDefault();
      var _that       = $(this),
          _type       = _that.val();
      switch(_type) {

        case "package":
            $(".table.service-default").addClass("d-none");
            $(".table.service-package").removeClass("d-none");
            $(".table.service-custom-comments").addClass("d-none");
            $(".table.service-mentions-with-hashtags").addClass("d-none");
            $(".table.service-mentions-custom-list").addClass("d-none");
            $(".table.service-mentions-hashtag").addClass("d-none");
            $(".table.service-mentions-user-followers").addClass("d-none");
            $(".table.service-mentions-media-likers").addClass("d-none");
            $(".table.service-custom-comments-package").addClass("d-none");
            $(".table.service-comment-likes").addClass("d-none");
            $(".table.service-subscriptions").addClass("d-none");
          break;
        case "custom_comments":
            $(".table.service-default").addClass("d-none");
            $(".table.service-package").addClass("d-none");
            $(".table.service-custom-comments").removeClass("d-none");
            $(".table.service-mentions-with-hashtags").addClass("d-none");
            $(".table.service-mentions-custom-list").addClass("d-none");
            $(".table.service-mentions-hashtag").addClass("d-none");
            $(".table.service-mentions-user-followers").addClass("d-none");
            $(".table.service-mentions-media-likers").addClass("d-none");
            $(".table.service-custom-comments-package").addClass("d-none");
            $(".table.service-comment-likes").addClass("d-none");
            $(".table.service-subscriptions").addClass("d-none");
          break;
        case "mentions_with_hashtags":
            $(".table.service-default").addClass("d-none");
            $(".table.service-package").addClass("d-none");
            $(".table.service-custom-comments").addClass("d-none");
            $(".table.service-mentions-with-hashtags").removeClass("d-none");
            $(".table.service-mentions-custom-list").addClass("d-none");
            $(".table.service-mentions-hashtag").addClass("d-none");
            $(".table.service-mentions-user-followers").addClass("d-none");
            $(".table.service-mentions-media-likers").addClass("d-none");
            $(".table.service-custom-comments-package").addClass("d-none");
            $(".table.service-comment-likes").addClass("d-none");
            $(".table.service-subscriptions").addClass("d-none");
          break;
        case "mentions_custom_list":
            $(".table.service-default").addClass("d-none");
            $(".table.service-package").addClass("d-none");
            $(".table.service-custom-comments").addClass("d-none");
            $(".table.service-mentions-with-hashtags").addClass("d-none");
            $(".table.service-mentions-custom-list").removeClass("d-none");
            $(".table.service-mentions-hashtag").addClass("d-none");
            $(".table.service-mentions-user-followers").addClass("d-none");
            $(".table.service-mentions-media-likers").addClass("d-none");
            $(".table.service-custom-comments-package").addClass("d-none");
            $(".table.service-comment-likes").addClass("d-none");
            $(".table.service-subscriptions").addClass("d-none");
          break;
        case "mentions_hashtag":
            $(".table.service-default").addClass("d-none");
            $(".table.service-package").addClass("d-none");
            $(".table.service-custom-comments").addClass("d-none");
            $(".table.service-mentions-with-hashtags").addClass("d-none");
            $(".table.service-mentions-custom-list").addClass("d-none");
            $(".table.service-mentions-hashtag").removeClass("d-none");
            $(".table.service-mentions-user-followers").addClass("d-none");
            $(".table.service-mentions-media-likers").addClass("d-none");
            $(".table.service-custom-comments-package").addClass("d-none");
            $(".table.service-comment-likes").addClass("d-none");
            $(".table.service-subscriptions").addClass("d-none");
          break;
        case "mentions_user_followers":
            $(".table.service-default").addClass("d-none");
            $(".table.service-package").addClass("d-none");
            $(".table.service-custom-comments").addClass("d-none");
            $(".table.service-mentions-with-hashtags").addClass("d-none");
            $(".table.service-mentions-custom-list").addClass("d-none");
            $(".table.service-mentions-hashtag").addClass("d-none");
            $(".table.service-mentions-user-followers").removeClass("d-none");
            $(".table.service-mentions-media-likers").addClass("d-none");
            $(".table.service-custom-comments-package").addClass("d-none");
            $(".table.service-comment-likes").addClass("d-none");
            $(".table.service-subscriptions").addClass("d-none");
          break;

        case "mentions_media_likers":
            $(".table.service-default").addClass("d-none");
            $(".table.service-package").addClass("d-none");
            $(".table.service-custom-comments").addClass("d-none");
            $(".table.service-mentions-with-hashtags").addClass("d-none");
            $(".table.service-mentions-custom-list").addClass("d-none");
            $(".table.service-mentions-hashtag").addClass("d-none");
            $(".table.service-mentions-user-followers").addClass("d-none");
            $(".table.service-mentions-media-likers").removeClass("d-none");
            $(".table.service-custom-comments-package").addClass("d-none");
            $(".table.service-comment-likes").addClass("d-none");
            $(".table.service-subscriptions").addClass("d-none");
          break;

        case "custom_comments_package":
            $(".table.service-default").addClass("d-none");
            $(".table.service-package").addClass("d-none");
            $(".table.service-custom-comments").addClass("d-none");
            $(".table.service-mentions-with-hashtags").addClass("d-none");
            $(".table.service-mentions-custom-list").addClass("d-none");
            $(".table.service-mentions-hashtag").addClass("d-none");
            $(".table.service-mentions-user-followers").addClass("d-none");
            $(".table.service-mentions-media-likers").addClass("d-none");
            $(".table.service-custom-comments-package").removeClass("d-none");
            $(".table.service-comment-likes").addClass("d-none");
            $(".table.service-subscriptions").addClass("d-none");
          break;
  
        case "comment_likes":
            $(".table.service-default").addClass("d-none");
            $(".table.service-package").addClass("d-none");
            $(".table.service-custom-comments").addClass("d-none");
            $(".table.service-mentions-with-hashtags").addClass("d-none");
            $(".table.service-mentions-custom-list").addClass("d-none");
            $(".table.service-mentions-hashtag").addClass("d-none");
            $(".table.service-mentions-user-followers").addClass("d-none");
            $(".table.service-mentions-media-likers").addClass("d-none");
            $(".table.service-custom-comments-package").addClass("d-none");
            $(".table.service-comment-likes").removeClass("d-none");
            $(".table.service-subscriptions").addClass("d-none");
          break;

        case "subscriptions":
            $(".table.service-default").addClass("d-none");
            $(".table.service-package").addClass("d-none");
            $(".table.service-custom-comments").addClass("d-none");
            $(".table.service-mentions-with-hashtags").addClass("d-none");
            $(".table.service-mentions-custom-list").addClass("d-none");
            $(".table.service-mentions-hashtag").addClass("d-none");
            $(".table.service-mentions-user-followers").addClass("d-none");
            $(".table.service-mentions-media-likers").addClass("d-none");
            $(".table.service-custom-comments-package").addClass("d-none");
            $(".table.service-comment-likes").addClass("d-none");
            $(".table.service-subscriptions").removeClass("d-none");
          break;

        default:
            $(".table.service-default").removeClass("d-none");
            $(".table.service-package").addClass("d-none");
            $(".table.service-custom-comments").addClass("d-none");
            $(".table.service-mentions-with-hashtags").addClass("d-none");
            $(".table.service-mentions-custom-list").addClass("d-none");
            $(".table.service-mentions-hashtag").addClass("d-none");
            $(".table.service-mentions-user-followers").addClass("d-none");
            $(".table.service-mentions-media-likers").addClass("d-none");
            $(".table.service-custom-comments-package").addClass("d-none");
            $(".table.service-comment-likes").addClass("d-none");
            $(".table.service-subscriptions").addClass("d-none");
          break;
      }
    })  

  </script>


  <div class="col-md-8">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title"><?=lang("status_order")?></h3>
        <div class="card-options">
          <a href="#" class="card-options-collapse" data-toggle="card-collapse"><i class="fe fe-chevron-up"></i></a>
          <a href="#" class="card-options-remove" data-toggle="card-remove"><i class="fe fe-x"></i></a>
        </div>
      </div>
      <div class="card-body">

        <div class="x_content">
          <table class="table table-hover table-bordered projects">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <?php
                if (!empty($status_order)) {
                  foreach ($status_order as $key => $row) {
              ?>
              <tr>
                <td><?=$key?></td>
                <td><?=$row?></td>
              </tr>
              <?php }} ?>
            </tbody>
          </table>


          <div class="title"><h4><?=lang("example_response")?></h4></div>
          <div class="card-body">
            <pre>
{
  "order": "32",
  "status": "pending",
  "charge": "0.0360",
  "start_count": "0",
  "remains": "0"
}
            </pre>
          </div>
        </div>

      </div>
    </div>
  </div>

  <div class="col-md-8">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title"> <?=lang("multiple_orders_status")?></h3>
        <div class="card-options">
          <a href="#" class="card-options-collapse" data-toggle="card-collapse"><i class="fe fe-chevron-up"></i></a>
          <a href="#" class="card-options-remove" data-toggle="card-remove"><i class="fe fe-x"></i></a>
        </div>
      </div>
      <div class="card-body">
        <div class="x_content">
          <table class="table table-hover table-bordered projects">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <?php
                if (!empty($status_orders)) {
                  foreach ($status_orders as $key => $row) {
              ?>
              <tr>
                <td><?=$key?></td>
                <td><?=$row?></td>
              </tr>
              <?php }} ?>
            </tbody>
          </table>


          <div class="title"><h4><?=lang("example_response")?></h4></div>
          <div class="card-body">
            <pre>
  {
      "12": {
          "order": "12",
          "status": "processing",
          "charge": "1.2600",
          "start_count": "0",
          "remains": "0"
      },
      "2": "Incorrect order ID",
      "13": {
          "order": "13",
          "status": "pending",
          "charge": "0.6300",
          "start_count": "0",
          "remains": "0"
      }
  }
            </pre>
          </div>
        </div>

      </div>
    </div>
  </div>
  
  <div class="col-md-8">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title"><?=lang("services_lists")?></h3>
        <div class="card-options">
          <a href="#" class="card-options-collapse" data-toggle="card-collapse"><i class="fe fe-chevron-up"></i></a>
          <a href="#" class="card-options-remove" data-toggle="card-remove"><i class="fe fe-x"></i></a>
        </div>
      </div>
      <div class="card-body">
        <div class="x_content">
          <table class="table table-hover table-bordered projects">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <?php
                if (!empty($services)) {
                  foreach ($services as $key => $row) {
              ?>
              <tr>
                <td><?=$key?></td>
                <td><?=$row?></td>
              </tr>
              <?php }} ?>
            </tbody>
          </table>
          <div class="title"><h4><?=lang("example_response")?></h4></div>
          <div class="card-body">
            <pre>
[
  {
      "service": "5",
      "name": "Instagram Followers [15K] ",
      "category": "Instagram - Followers [Guaranteed\/Refill] - Less Drops \u2b50",
      "rate": "1.02",
      "min": "500",
      "max": "10000"
      "type": default
      "desc": usernames
      "dripfeed": 1
  },
  {
      "service": "9",
      "name": "Instagram Followers - Max 300k - No refill - 30-40k\/Day",
      "category": "Instagram - Followers [Guaranteed\/Refill] - Less Drops \u2b50",
      "rate": "0.04",
      "min": "500",
      "max": "300000"
      "type": default
      "desc": usernames
      "dripfeed": 1
  },
  {
      "service": "10",
      "name": "Instagram Followers ( 30 days auto refill ) ( Max 350K ) (Indian Majority )",
      "category": "Instagram - Followers [Guaranteed\/Refill] - Less Drops \u2b50",
      "rate": "1.2",
      "min": "100",
      "max": "350000"
      "type": default
      "desc": usernames
      "dripfeed": 1
  }
]
            </pre>
          </div>
        </div>
      </div>
    </div>
  </div>  

  <div class="col-md-8">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title"><?=lang("Balance")?></h3>
        <div class="card-options">
          <a href="#" class="card-options-collapse" data-toggle="card-collapse"><i class="fe fe-chevron-up"></i></a>
          <a href="#" class="card-options-remove" data-toggle="card-remove"><i class="fe fe-x"></i></a>
        </div>
      </div>
      <div class="card-body">
        
        <div class="x_content">
          <table class="table table-hover table-bordered projects">
            <thead>
              <tr>
                <th><?=lang("parameter")?></th>
                <th><?=lang("Description")?></th>
              </tr>
            </thead>
            <tbody>
              <?php
                if (!empty($balance)) {
                  foreach ($balance as $key => $row) {
              ?>
              <tr>
                <td><?=$key?></td>
                <td><?=$row?></td>
              </tr>
              <?php }} ?>
            </tbody>
          </table>
          <div class="title"><h4><?=lang("example_response")?></h4></div>
          <div class="card-body">
            <pre>
  {
      "status": "success",
      "balance": "0.03",
      "currency": "USD"
  }
            </pre>
          </div>
        </div>
      </div>
    </div>
  </div>

</div>
<!--add by morteza-->
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript">



    $(document).ready(function () {
        //کپی پیوند
        $(document).on('click', '.CopyToClipBoard', function (event) {
            event.preventDefault();

            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val($(this).attr('href')).select();
            document.execCommand("copy");
            $temp.remove();

            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000
            })

            Toast.fire({
                type: 'success',
                title: 'کپی شد',
                customClass: {
                    popup: 'copy-rad',
                }
            })


        });


    });
</script>
