<?php
$setting_sidebar = [
    'general_setting' => [
        'name' => 'تنظیمات عمومی', 'icon' => 'fe fe-disc', 'area_title' => true, 'route-name' => '#',
        'elements' => [
            'website_setting' => ['name' => 'تنظیمات وبسایت', 'icon' => 'fe fe-globe', 'area_title' => false, 'route-name' => 'website_setting'],
            'website_logo' => ['name' => 'لوگو وبسایت', 'icon' => 'fe fe-image', 'area_title' => false, 'route-name' => 'website_logo'],
            'default' => ['name' => 'تنظیمات پیشفرض', 'icon' => 'fe fe-box', 'area_title' => false, 'route-name' => 'default'],
            'template' => ['name' => 'قالب', 'icon' => 'fe fe-layout', 'area_title' => false, 'route-name' => 'template'],
            'cookie_policy' => ['name' => 'خط مشی کوکی', 'icon' => 'fe fe-bookmark', 'area_title' => false, 'route-name' => 'cookie_policy'],
            'terms_policy' => ['name' => 'قوانین و مقررات', 'icon' => 'fe fe-award', 'area_title' => false, 'route-name' => 'terms_policy'],
            'currency' => ['name' => 'واحد پول', 'icon' => 'fe fe-dollar-sign', 'area_title' => false, 'route-name' => 'currency'],
            'other' => ['name' => 'دیگر تنظیمات', 'icon' => 'fe fe-command', 'area_title' => false, 'route-name' => 'other'],
            'namad' => ['name' => 'نمادها', 'icon' => 'fe fe-command', 'area_title' => false, 'route-name' => 'namad'],
            'cron' => ['name' => 'تنظیمات کرون جاب ها', 'icon' => 'fe fe-clock', 'area_title' => false, 'route-name' => 'cron'],
        ],
    ],
    'email' => [
        'name' => 'ایمیل', 'icon' => 'fe fe-disc', 'area_title' => true, 'route-name' => '#',
        'elements' => [
            'email_setting' => ['name' => 'تنظیمات ایمیل', 'icon' => 'fe fe-mail', 'area_title' => false, 'route-name' => 'email_setting'],
            'email_template' => ['name' => 'قالب ایمیل', 'icon' => 'fe fe-file-text', 'area_title' => false, 'route-name' => 'email_template'],
        ],
    ],
    'integrations' => [
        'name' => 'ضمیمه ها', 'icon' => 'fe fe-disc', 'area_title' => true, 'route-name' => '#',
        'elements' => [
            'payments' => ['name' => 'پرداخت های دستی', 'icon' => 'fe fe-file-text', 'area_title' => false, 'route-name' => 'payment'],
        ],
    ],
    'sms' => [//morteza
        'name' => 'تنظیمات پیامک', 'icon' => 'fe fe-mobile', 'area_title' => true, 'route-name' => '#',
        'elements' => [
            'farazsms_setting' => ['name' => 'تنظیمات فراز اس ام اس', 'icon' => 'fe fe-file-text', 'area_title' => false, 'route-name' => 'farazsms_setting'],
            'sms_settings' => ['name' => 'تنظیمات پیامک', 'icon' => 'fe fe-file-text', 'area_title' => false, 'route-name' => 'sms_settings'],
            'sms_templates' => ['name' => 'قالب های پیامک', 'icon' => 'fe fe-file-text', 'area_title' => false, 'route-name' => 'sms_templates'],
        ],
    ],
];

////add for affiliate
$affiliate_exist = get_field(PURCHASE, ['pid' => 27553], 'purchase_code');
if($affiliate_exist){
    $setting_sidebar['general_setting']['elements']['affiliate'] =  ['name' => 'تنظیمات افزونه بازاریابی', 'icon' => 'fe fe-settings', 'area_title' => false, 'route-name' => 'affiliate'];
}

$xhtml = '<div class="sidebar o-auto">';
$i = 0;
foreach ($setting_sidebar as $key => $item) {
    $xhtml .= sprintf('
        <div class="list-group list-group-transparent mb-0 mt-5">
          <h5><span class="icon mr-3"><i class="%s"></i></span>%s</h5>
        </div>', $item['icon'], $item['name']
    );
    if (!empty($item['elements'])) {
        $xhtml_child = '<div class="list-group list-group-transparent mb-0">';
        foreach ($item['elements'] as $element) {
            $link = admin_url('settings/' . $element['route-name']);
            $class_active = ($element['route-name'] == segment(3)) ? 'active' : '';
            $xhtml_child .= sprintf(
                '<a href="%s" class="list-group-item list-group-item-action %s"><span class="icon mr-3"><i class="%s"></i></span>%s</a>', $link, $class_active, $element['icon'], $element['name']
            );
        }
        $xhtml_child .= '</div>';
    }
    $i++;
    $xhtml .= $xhtml_child;

}
$xhtml .= '</div>';
echo $xhtml;
?>
