<?php
$form_url = admin_url($controller_name . "/store/");
$form_attributes = array('class' => 'form actionForm', 'data-redirect' => get_current_url(), 'method' => "POST");
?>
<style>
    .smart-remove {
        position: absolute;
        right: 18px;
        top: 3px;
        color: #E84393;
        background: #fff;
        padding: 3px;
        border: 1px solid #d9d8d8;
        border-radius: 3px;
    }
    .swal2-popup.swal2-toast .swal2-title {
        font-size: 12px !important;
        text-align: center !important;
    }

    .smart-create-cronjob{
        margin: 10px auto;
    }

    .disable-click{
        pointer-events:none;
    }
</style>
<div class="card content">
    <div class="card-header">
        <h3 class="card-title"><i class="fe fe-clock"></i> تنظیمات کرون جاب</h3>
    </div>
    <?php echo form_open($form_url, $form_attributes); ?>
    <div class="card-body">
        <div class="row">
            <div class="col-md-12 col-lg-12">

                <h5 class="text-info"><i class="fe fe-link"></i> در هر درخواست بروزرسانی وضعیت ها، چند سفارش بررسی شود</h5>
                <div class="row">

                    <div class="col-md-4">
                        <div class="form-group">
                            <label>انتخاب تعداد</label>
                            <select name="cron_status_number" class="form-control square">
                                <?php
                                $cronjob_list = [15, 30, 60, 120, 240, 480];
                                foreach ($cronjob_list as $order_number) {
                                    ?>
                                    <option value="<?= $order_number ?>" <?= (get_option("cron_status_number", 15) == $order_number) ? "selected" : '' ?>><?= $order_number ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="alert alert-danger">
                        نکات:<br>
                        دقت داشته باشید که ساخت کرون جاب برای یک بار کافی است و اگر مشکل عدم ارسال سفارشات به ارائه دهنده و یا بروز نشدن وضعیت سفارشات داشتید مشکل از لینک کرون جاب نیست و کافیست که این لینک با اونی که در هاست تنظیم کردین یکی باشه<br>
                    </div>
                    <div class="text-end smart-create-cronjob">
                        <a href="#" class="btn btn-amber btn-min-width text-uppercase create-cronjob-key">ساخت لینک کرون جاب جدید</a>
                    </div>
                    <?php
                    $home_url = site_url();
                    $cronjob_key = get_option("cron_key", "");
                    if ($cronjob_key) {
                        $order_link = "/usr/bin/wget -q -O /dev/null '" . $home_url . "cron/order/" . $cronjob_key . "' >/dev/null 2>&1 ";
                        $status_link = "/usr/bin/wget -q -O /dev/null '" . $home_url . "cron/multiple_status/" . $cronjob_key . "' >/dev/null 2>&1 ";
                        $dripfeed_link = "/usr/bin/wget -q -O /dev/null '" . $home_url . "cron/dripfeed/" . $cronjob_key . "' >/dev/null 2>&1 ";
                        $subscriptions_link = "/usr/bin/wget -q -O /dev/null '" . $home_url . "cron/subscriptions/" . $cronjob_key . "' >/dev/null 2>&1 ";
                        $hidden = false;
                    } else {
                        $order_link = "";
                        $status_link = "";
                        $dripfeed_link = "";
                        $subscriptions_link = "";
                        $hidden = true;
                    }


                    ?>
                    <div class="col-md-12">
                        <div class="form-group clearfix"  <?php if ($hidden) {
                            echo "style='display:none'";
                        } ?>>
                            <label class=" col-md-12">لینک کرون جاب ارسال سفارش(هر 1 دقیقه یک بار)</label>
                            <div class="col-md-12">
                                <input type="text" value="<?= $order_link ?>" readonly dir="ltr" class="form-control cron_order"/>
                                <a href="<?= $order_link ?>" class="smart-remove CopyToClipBoard cron_order"><i class="fa fa-copy"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group clearfix"  <?php if ($hidden) {
                            echo "style='display:none'";
                        } ?>>
                            <label class=" col-md-12">لینک کرون جاب دریافت وضعیت ها(حتما هر 5 دقیقه یک بار)</label>
                            <div class="col-md-12">
                                <input type="text" value="<?= $status_link ?>" readonly dir="ltr" class="form-control cron_status"/>
                                <a href="<?= $status_link ?>" class="smart-remove CopyToClipBoard cron_status"><i class="fa fa-copy"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group clearfix"  <?php if ($hidden) {
                            echo "style='display:none'";
                        } ?>>
                            <label class=" col-md-12">لینک کرون جاب وضعیت سفارشات قطره ای(هر 1 دقیقه یک بار)</label>
                            <div class="col-md-12">
                                <input type="text" value="<?= $dripfeed_link ?>" readonly dir="ltr" class="form-control cron_dripfeed"/>
                                <a href="<?= $dripfeed_link ?>" class="smart-remove CopyToClipBoard cron_dripfeed"><i class="fa fa-copy"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group clearfix"  <?php if ($hidden) {
                            echo "style='display:none'";
                        } ?>>
                            <label class=" col-md-12">لینک کرون جاب اشتراک ها(هر 1 دقیقه یک بار)</label>
                            <div class="col-md-12">
                                <input type="text" value="<?= $subscriptions_link ?>" readonly dir="ltr" class="form-control cron_subscriptions"/>
                                <a href="<?= $subscriptions_link ?>" class="smart-remove CopyToClipBoard cron_subscriptions"><i class="fa fa-copy"></i></a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="card-footer text-end">
        <button class="btn btn-primary btn-min-width text-uppercase"><?= lang("Save") ?></button>
    </div>
    <?php echo form_close(); ?>
</div>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript">



    $(document).ready(function () {
        //کپی پیوند
        $(document).on('click', '.CopyToClipBoard', function (event) {
            event.preventDefault();

            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val($(this).attr('href')).select();
            document.execCommand("copy");
            $temp.remove();

            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000
            })

            Toast.fire({
                type: 'success',
                title: 'کپی شد',
                customClass: {
                    popup: 'copy-rad',
                }
            })


        });

        //کپی پیوند
        $(document).on('click', '.create-cronjob-key', function (event) {
            event.preventDefault();
            var token = $('.actionForm').find("input[name=token]").val();
            $(this).addClass("disable-click");
            $.ajax({
                url: '<?=$form_url?>',
                type: 'post',
                data: {token: token,'cron_key':1},
                success: function (response) {
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'bottom',
                        showConfirmButton: false,
                        timer: 2000
                    })

                    Toast.fire({
                        type: 'success',
                        title: "لینک های کرون جاب با موفقیت ساخته شدند",
                        customClass: {
                            popup: 'copy-rad',
                        }
                    })

                    reloadPage();
                },
                error: function () {

                }
            });




        });

    });
</script>