<?php
// Page header
echo show_page_header($controller_name, ['page-options' => 'add-new', 'page-options-type' => 'ajax-modal']);
?>

<div class="row">
    <?php if(!empty($items)){
        ?>
        <div class="col-md-12 col-xl-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><?=lang("Lists")?></h3>
                    <div class="card-options">
                        <?php echo show_bulk_btn_action($controller_name); ?>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover table-bordered table-vcenter card-table">
                        <?php echo render_table_thead($columns); ?>
                        <tbody>
                        <?php
                        if (!empty($items)) {
                            $i = $from;
                            foreach ($items as $key => $item) {
                                switch ($item['type']) {
                                    case 'home_page':
                                        $type = 'صفحه اصلی';
                                        $color = "btn-info";
                                        break;
                                    case 'order_page':
                                        $type = 'صفحه ارسال سفارش';
                                        $color = "btn-orange";
                                        break;
                                    case 'add_funds_page':
                                        $type = 'صفحه افزودن اعتبار';
                                        $color = "btn-lime";
                                        break;
                                }


                                $i++;
                                $item_checkbox      = show_item_check_box('check_item', $item['id']);
                                $item_status        = show_item_status($controller_name, $item['id'], $item['status'], 'switch');
                                $show_item_buttons  = show_item_button_action($controller_name, $item['id']);
                                $description  = show_high_light(show_content(html_entity_decode($item['description'], ENT_QUOTES), 100), $params['search'], 'answer');
                                ?>
                                <tr class="tr_<?php echo esc($item['id']); ?>">
                                    <th class="text-center w-1"><?php echo $item_checkbox; ?></th>
                                    <td class="text-center text-muted"><?=$i?></td>
                                    <td>
                                        <p class="text-muted"><?php echo $description; ?></p>
                                    </td>
                                    <td><?= $type ?></td>
                                    <td class="text-center w-10p"><?php echo $item['changed'] ?></td>
                                    <td class="text-center w-5p"><?php echo $item_status; ?></td>
                                    <td class="text-center w-5p"><?php echo $show_item_buttons; ?></td>
                                </tr>
                            <?php }}?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php echo show_pagination($pagination); ?>
    <?php }else{
        echo show_empty_item();
    }?>
</div>
