<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class transactions extends WP_BAZAR_SMARTPANEL_AdminController {

    public function __construct(){
        parent::__construct();
        $this->load->model(get_class($this).'_model', 'main_model');

        $this->controller_name   = strtolower(get_class($this));
        $this->controller_title  = ucfirst(str_replace('_', ' ', get_class($this)));
        $this->path_views        = "transactions";
        $this->params            = [];

        $this->columns     =  array(
            "user"             => ['name' => 'کاربر',    'class' => ''],
            "transaction_id"   => ['name' => 'شناسه تراکنش', 'class' => 'text-center'],
            "payment"          => ['name' => 'پرداخت',  'class' => 'text-center'],
            "amount"           => ['name' => 'مبلغ',  'class' => 'text-center'],
            "tnx_fee"          => ['name' => 'کارمزد تراکنش',  'class' => 'text-center'],
            "note"             => ['name' => 'یادداشت',  'class' => 'text-center'],
            "created"          => ['name' => 'ساخته شده',  'class' => 'text-center'],
            "Status"           => ['name' => 'وضعیا',  'class' => 'text-center'],
        );
    }

    public function store(){
        if (!$this->input->is_ajax_request()) redirect(admin_url($this->controller_name));
        $this->form_validation->set_rules('status', 'Status', 'trim|required|integer|in_list[-1,0,1]|xss_clean',[
            'in_list' => 'وضعیت نامعتبر است',
        ]);
        if (!$this->form_validation->run()) _validation('error', validation_errors());
        if($this->input->post('ids')){
            $task   = 'edit-item';
        }
        $response = $this->main_model->save_item( $this->params, ['task' => $task]);
        ms($response);
    }

}