<?php
defined('BASEPATH') or exit('No direct script access allowed');

class tickets extends WP_BAZAR_SMARTPANEL_AdminController
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model(get_class($this) . '_model', 'main_model');

        $this->controller_name = strtolower(get_class($this));
        $this->controller_title = ucfirst(str_replace('_', ' ', get_class($this)));
        $this->path_views = "tickets";
        $this->params = [];

        $this->columns = array(
            "id" => ['name' => 'شناسه', 'class' => 'text-center'],
            "user" => ['name' => 'کاربر', 'class' => 'text-center'],
            "subject" => ['name' => 'موضوع', 'class' => 'text-center'],
            "status" => ['name' => 'وضعیت', 'class' => 'text-center'],
            "created" => ['name' => 'ساخته شده', 'class' => 'text-center'],
        );
    }

    public function view($id = "")
    {
        $item = $this->main_model->get_item(['id' => (int) $id], ['task' => 'view-get-item']);
        if (!$item) {
            redirect(admin_url($this->controller_name));
        }

        $items_ticket_message = $this->main_model->list_items(['ticket_id' => $id], ['task' => 'list-items-ticket-message']);
        $data = array(
            "controller_name" => $this->controller_name,
            "item" => $item,
            "items_ticket_message" => $items_ticket_message,
        );
        $this->template->build($this->path_views . '/view', $data);
    }

    public function store()
    {
        if (!$this->input->is_ajax_request()) {
            redirect(admin_url($this->controller_name));
        }

        $this->form_validation->set_rules('message', 'message', 'trim|required|xss_clean');

        if (!$this->form_validation->run()) {
            _validation('error', validation_errors());
        }
        if (!$this->input->post('ids')) {
            _validation('error', 'درخواست شما اشکالاتی داشت');
        }
        $task = 'add-item-ticket-massage';
        $response = $this->main_model->save_item(null, ['task' => $task]);
        ms($response);
    }

    // Change status
    public function change_status($status = "", $id = "")
    {
        if (!in_array($status, ['closed', 'pending', 'unread', 'answered']) || !$id) {
            redirect(admin_url($this->controller_name));
        }
        $params = [
            'id' => $id,
            'status' => $status,
        ];
        $response = $this->main_model->save_item($params, ['task' => 'change-status']);
        if ($response['status'] && $status == 'unread') {
            redirect(admin_url($this->controller_name));
        } else {
            redirect(admin_url($this->controller_name . '/view/' . $id));
        }
    }

    public function delete_item_ticket_message($ids = "")
    {
        if (!$this->input->is_ajax_request()) redirect(admin_url($this->controller_name));
        $response = $this->main_model->delete_item(['ids' => $ids], ['task' => 'delete-item-ticket-message']);
        ms($response);
    }
}
