<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class subscriptions extends WP_BAZAR_SMARTPANEL_AdminController {

    public function __construct(){
        parent::__construct();
        $this->load->model(get_class($this).'_model', 'main_model');

        $this->controller_name   = strtolower(get_class($this));
        $this->controller_title  = ucfirst(str_replace('_', ' ', get_class($this)));
        $this->path_views        = "subscriptions";
        $this->params            = [];

        $this->columns     =  array(
            "id"                => ['name' => 'شناسه سفارش',    'class' => ''],
            "user"              => ['name' => 'کاربر', 'class' => ''],
            "order_details"     => ['name' => 'جزییات سفارش', 'class' => 'text-center'],
            "created"           => ['name' => 'ساخته شده', 'class' => 'text-center'],
            "updated"           => ['name' => 'آپدیت شده', 'class' => 'text-center'],
            "response"          => ['name' => 'پاسخ API', 'class' => 'text-center'],
            "status"            => ['name' => 'وضعیت',  'class' => 'text-center'],
        );
    }

    public function store(){
        if (!$this->input->is_ajax_request()) redirect(admin_url($this->controller_name));
        $this->form_validation->set_rules('username', 'link', 'trim|required|xss_clean');
        $this->form_validation->set_rules('sub_status', 'status', 'trim|required|xss_clean');
        if (!$this->form_validation->run()) _validation('error', validation_errors());
        $task   = 'edit-item';
        $response = $this->main_model->save_item( $this->params, ['task' => $task]);
        ms($response);
    }
}