<?php
defined('BASEPATH') or exit('No direct script access allowed');

class statistics extends WP_BAZAR_SMARTPANEL_AdminController
{

    private $tb_main = CATEGORIES;

    public function __construct()
    {
        parent::__construct();
        $this->load->model(get_class($this) . '_model', 'main_model');

        $this->controller_name = strtolower(get_class($this));
        $this->controller_title = ucfirst(str_replace('_', ' ', get_class($this)));
        $this->path_views = "statistics";
        $this->params = [];
    }

    public function index()
    {
        $this->load->model('Users_model');
        $items_last_users = $this->Users_model->list_items(['limit' => 5], ['task' => 'items-last-users']);
        $header_area = $this->main_model->header_statistics();
        $chart_and_orders_area = $this->main_model->chart_and_orders_statistics();
        $header_area['orders']['value'] = $chart_and_orders_area['orders_statistics']['orders']['value'];

        $this->load->model('order_model');
        $items_best_seller = $this->order_model->list_items(['limit' => 5], ['task' => 'best-seller-in-statistics']);

        //alert add by morteza
        $this->load->model('alerts_model');
        $items_alerts = $this->alerts_model->list_items([],['task' => 'list-items2']);

        $data = array(
            "controller_name" => $this->controller_name,
            "header_area" => $header_area,
            "chart_and_orders_area" => $chart_and_orders_area,
            "items_last_users" => $items_last_users,
            "items_best_seller" => $items_best_seller,
            "alerts" => $items_alerts,//for alerts 3.4.5
        );

        $this->template->build($this->path_views . "/index", $data);
    }
}